local TABAS_BathSaltDefs = {}


--[[
-- **** Bath Benefits ****
--Stats
    "Anger",
    "Fatigue", -- Reduces fatigue to 45.
    "FatigueBase", -- Slowly reduces fatigue to 60.
    "Sanity",
    "Stress",
    "StressFromCigarettes",

--BodyDamage
    "Cold",
    "Boredom",
    "Unhappyness", -- Reduces unhappiness.
    "Drunkenness",
    "DrunkennessInc",
    "Health",  -- In most cases, it won't be very effective because other factors will reduce your health.

--Character -- These give various pill effects. 
    "Sleep",
    "AntiDepress",
    "Panic",
    "Pain",

--BodyParts
    "Burn",  
    "Fracture",
    "PartHealth",
    "AdditionalPainInc", -- If has injury, add additional pain.
    "AdditionalPain",
    "Bite",
    "Cut",
    "DeepWound",
    "Scratch",
    "Stitch",
    "WoundInfection",
    "Stiffness",

    "Injuries_Sustain",  -- Gain Plantain
    "Fracture_Sustain",  -- Gain Comfrey
    "WoundInfection_Sustain", -- Gain Garlic
]]

TABAS_BathSaltDefs.BenefitCategories = {
    ["BurnedTreatment"] = {"Burn", "WoundInfection", "AdditionalPain"},
    ["CalmMind"] = {"Sanity", "Panic", "Anger"},
    ["DrunkennessRelief"] = {"Drunkenness"},
    ["FatigueRecovery"] = {"Fatigue"},
    ["FeelingHappiness"] = {"AntiDepress", "Boredom", "Stress", "Panic"},
    ["FractureRecovery"] = {"Fracture", "AdditionalPain"},
    ["GoodSleep"] = {"Sleep", "Boredom", "FatigueBase"},
    ["WoundRecovery"] = {"Bite", "Cut", "DeepWound", "Scratch", "Stitch", "WoundInfection"},
    ["MuscleStrainRelief"] = {"Stiffness"},
    ["PainRelief"] = {"Pain", "AdditionalPain"},
    ["PreventsCold"] = {"Cold"},
    ["StressRelief"] = {"Stress", "StressFromCigarettes"},

    -- ["FractureRecovery2"] = {"Fracture_Sustain", "Pain", "PartHealth"},
    -- ["WoundRecovery2"] = {"Injuries_Sustain", "WoundInfection_Sustain", "PartHealth"},
}

TABAS_BathSaltDefs.BathSaltTypes = {
    Lavender = {
        type = "Lavender",
        itemType = "TABAS.BathSalt_Lavender",
        fluidType = "BathSaltWater_Lavender",
        name = getText("IGUI_TABAS_BathSalt_Lavender"),
        color = "MediumPurple", -- There refers to the ColorReference in script/fluids.
        benefitCategories = {"GoodSleep", "CalmMind", "StressRelief", "PainRelief"},
    },
    Citrus = {
        type = "Citrus",
        itemType = "TABAS.BathSalt_Citrus",
        fluidType = "BathSaltWater_Citrus",
        name = getText("IGUI_TABAS_BathSalt_Citrus"),
        color = "PaleGoldenrod",
        benefitCategories = {"DrunkennessRelief", "PreventsCold", "StressRelief", "MuscleStrainRelief"},
    },
    Floral = {
        type = "Floral",
        itemType = "TABAS.BathSalt_Floral",
        fluidType = "BathSaltWater_Floral",
        name = getText("IGUI_TABAS_BathSalt_Floral"),
        color = "LightPink",
        benefitCategories = {"FeelingHappiness", "BurnedTreatment", "CalmMind"}
    },
    Forest = {
        type = "Forest",
        itemType = "TABAS.BathSalt_Forest",
        fluidType = "BathSaltWater_Forest",
        name = getText("IGUI_TABAS_BathSalt_Forest"),
        color = "ForestGreen",
        benefitCategories = {"FractureRecovery", "PainRelief", "MuscleStrainRelief"}
    },
    Herb = {
        type = "Herb",
        itemType = "TABAS.BathSalt_Herb",
        fluidType = "BathSaltWater_Herb",
        name = getText("IGUI_TABAS_BathSalt_Herb"),
        color = "YellowGreen",
        benefitCategories = {"WoundRecovery", "PreventsCold"}
    },
    Rose = {
        type = "Rose",
        itemType = "TABAS.BathSalt_Rose",
        fluidType = "BathSaltWater_Rose",
        name = getText("IGUI_TABAS_BathSalt_Rose"),
        color = "Crimson",
        benefitCategories = {"CalmMind", "FatigueRecovery", "PreventsCold"}
    }
}

function TABAS_BathSaltDefs.getDef(typeName)
    local _prefix = "BathSalt_"
    if not string.find(typeName, _prefix) then
        print("Bath Salt Defs: Invalid type name requested!")
        return
    end
    local name = string.gsub(typeName, _prefix, "")
    for defType, def in pairs(TABAS_BathSaltDefs.BathSaltTypes) do
        if defType == name then
            return def
        end
    end
end

function TABAS_BathSaltDefs.getBathSaltBenefits(def)
    local result = {}
    local category
    local benefit
    local benefits
    for i=1, #def.benefitCategories do
        category = def.benefitCategories[i]
        if TABAS_BathSaltDefs.BenefitCategories[category] then
            benefits = TABAS_BathSaltDefs.BenefitCategories[category]
            for j=1, #benefits do
                benefit = benefits[j]
                if not result[benefit] then
                    table.insert(result, benefit)
                end
            end
        end
    end
    return result
end

return TABAS_BathSaltDefs